<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class GenerateToken extends Command
{
    protected $signature = 'token:generate {user_id}';
    protected $description = 'Genera un token para el usuario especificado';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $userId = $this->argument('user_id');
        $user = User::find($userId);

        if ($user) {
            $token = $user->createToken('Test Token')->plainTextToken;
            $this->info("Token generado para el usuario con ID {$userId}: {$token}");
        } else {
            $this->error("Usuario con ID {$userId} no encontrado.");
        }
    }
}

