<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Area;

class AreaController extends Controller
{
        
    //-----Listar todas las áreas-----
    public function index()
    {
        try {
            $areas = Area::all();
            return response()->json($areas, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Error al obtener las áreas'], 500);
        }
    }


    //-----Mostrar po id----
    public function show($id)
    {
        return response()->json(Area::findOrFail($id), 200);
    }

    //------Crear una nueva área------
    public function store(Request $request)
    {
        $this->authorize('create', Area::class);

        $validatedData = $request->validate([
            'nombre_area' => 'required|unique:areas|max:100',
            'descripcion' => 'nullable',
        ]);

        $area = Area::create($validatedData);

        return response()->json($area, 201);
    }

    //-----Actualizar un área------
    public function update(Request $request, $id)
    {
        $this->authorize('update', Area::class);

        $area = Area::findOrFail($id);

        $validatedData = $request->validate([
            'nombre_area' => 'required|max:100|unique:areas,nombre_area,' . $id,
            'descripcion' => 'nullable',
        ]);

        $area->update($validatedData);

        return response()->json($area, 200);
    }

    //-----Eliminar un área------
    public function destroy($id)
    {
        $this->authorize('delete', Area::class);

        $area = Area::findOrFail($id);
        $area->delete();

        return response()->json(null, 204);
    }
}
