<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Determinante;

class DeterminanteController extends Controller
{
    //-----Listar los determinantes--------
    
    public function index()
    {
        try {
            $determinantes = Determinante::select('nombre_determinante')->get();
            return response()->json($determinantes, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Error al obtener los determinantes'], 500);
        }
    }

    
    //-----Crear un nuevo determinante---------
    public function store(Request $request)
    {
        $this->authorize('create', Determinante::class);

        $validatedData = $request->validate([
            'nombre_determinante' => 'required|unique:determinantes|max:100',
            'descripcion' => 'nullable',
        ]);

        $determinante = Determinante::create($validatedData);

        return response()->json($determinante, 201);
    }

    //------Actualizar un determinante-----
    public function update(Request $request, $id)
    {
        $this->authorize('update', Determinante::class);

        $determinante = Determinante::findOrFail($id);

        $validatedData = $request->validate([
            'nombre_determinante' => 'required|max:100|unique:determinantes,nombre_determinante,' . $id,
            'descripcion' => 'nullable',
        ]);

        $determinante->update($validatedData);

        return response()->json($determinante, 200);
    }

    //------Eliminar un determinante-------
    public function destroy($id)
    {
        $this->authorize('delete', Determinante::class);

        $determinante = Determinante::findOrFail($id);
        $determinante->delete();

        return response()->json(null, 204);
    }
}



