<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\EstadoPublicacion;
use Illuminate\Http\Request;

class EstadoPublicacionController extends Controller
{
    // Obtener todos los estados de publicación
    public function index()
    {
        $estados = EstadoPublicacion::all();
        return response()->json($estados);
    }

    // Crear un nuevo estado de publicación
    public function store(Request $request)
    {
        $request->validate([
            'nombre_estado' => 'required|string|max:255',
            'descripcion' => 'nullable|string',
        ]);

        $estado = EstadoPublicacion::create($request->all());
        return response()->json($estado, 201);
    }

    // Obtener un estado de publicación específico
    public function show($id)
    {
        $estado = EstadoPublicacion::find($id);

        if (!$estado) {
            return response()->json(['message' => 'Estado de publicación no encontrado'], 404);
        }

        return response()->json($estado);
    }

    // Actualizar un estado de publicación específico
    public function update(Request $request, $id)
    {
        $estado = EstadoPublicacion::find($id);

        if (!$estado) {
            return response()->json(['message' => 'Estado de publicación no encontrado'], 404);
        }

        $request->validate([
            'nombre_estado' => 'required|string|max:255',
            'descripcion' => 'nullable|string',
        ]);

        $estado->update($request->all());
        return response()->json($estado);
    }

    // Eliminar un estado de publicación específico
    public function destroy($id)
    {
        $estado = EstadoPublicacion::find($id);

        if (!$estado) {
            return response()->json(['message' => 'Estado de publicación no encontrado'], 404);
        }

        $estado->delete();
        return response()->json(['message' => 'Estado de publicación eliminado']);
    }
}
