<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Rol;

class RolController extends Controller
{
    //-------Listar roles------
    public function index()
    {
        try {
            $roles = DB::table('roles')
                ->select('id_rol', 'nombre_rol')
                ->get();

            return response()->json([
                'message' => 'Lista de roles obtenida exitosamente',
                'roles' => $roles,
            ], 200);
        } catch (\Throwable $e) {
            return response()->json([
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ], 500);
        }
    }

    //------Crear un nuevo rol------
    public function store(Request $request)
    {
        $this->validateRol($request); 

        $role = Rol::create($request->all());
        return response()->json($role, 201);
    }

    //-----Actualizar un rol---------
    public function update(Request $request, $id)
    {
        $role = Rol::findOrFail($id);
        $this->validateRol($request, $id);  

        $role->update($request->all());

        return response()->json([
            'message' => 'Rol actualizado correctamente',
            'role' => $role
        ]);
    }

    // -----Eliminar un rol------
    public function destroy($id)
    {
        $role = Rol::findOrFail($id);
        $role->delete();
        return response()->json(['message' => 'Rol eliminado exitosamente']);
    }

    //--------Función privada para validaciones--------
    private function validateRol(Request $request, $id = null)
    {
        $request->validate([
            'nombre_rol' => 'required|string|unique:roles,nombre_rol,' . $id . ',id_rol',
        ]);
    }
}
