<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\EstadoUser;

class UserStatusController extends Controller
{
    //-----Listar los estados de usuarios-----
    public function index()
    {
        $estados = EstadoUser::all();
        return response()->json($estados);
    }

    //-----Actualizar estado de un usuario------
    public function updateStatus(Request $request, $id)
    {
        $request->validate([
            'id_estado_user' => 'required|exists:estado_users,id_estado_user',
        ]);

        $user = User::findOrFail($id);

        if ($user->roles()->where('nombre_rol', 'superadmin')->exists()) {
            
            $estadoCritico = [/*IDs o nombres de estados críticos*/];

            if (in_array($request->id_estado_user, $estadoCritico)) {
                return response()->json([
                    'message' => 'No se puede cambiar el estado de un usuario con rol SuperAdmin a este estado.'
                ], 403);
            }
        }

        //-----Se permite la actualización si no es SuperAdmin--------------
        $user->update(['id_estado_user' => $request->id_estado_user]);

        return response()->json(['message' => 'Estado de usuario actualizado correctamente']);
    }
}
