<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Models\User;
use Illuminate\Support\Str;

class PasswordResetController extends Controller
{
    
    public function forgot(Request $request)
{
    $request->validate(['email' => 'required|email']);
    
    $user = User::where('email', $request->email)->first();
    if (!$user) {
        return response()->json(['message' => 'Usuario no encontrado.'], 404);
    }
    
    $token = Password::broker()->createToken($user);
    
    $frontendUrl = env('FRONTEND_URL');
    $resetUrl = "$frontendUrl/reset-password?token=$token&email={$request->email}";

    Mail::send('emails.reset_password', ['url' => $resetUrl], function ($message) use ($request) {
        $message->to($request->email)->subject('Restablecimiento de Contraseña');
    });

    return response()->json(['message' => 'Te hemos enviado un correo. Sigue las instrucciones para acceder a tu cuenta de Hubprocosi.']);
}

    public function reset(Request $request)
    {
        $request->validate([
        'token' => 'required',
        'email' => 'required|email',
        'password' => 'required|min:8|confirmed',
    ]);


    $status = Password::reset(
        $request->only('email', 'password', 'password_confirmation', 'token'),
        function ($user, $password) {
            $user->forceFill([
                'password' => Hash::make($password),
            ])->save();
        }
    );


    if ($status === Password::PASSWORD_RESET) {
        return response()->json(['message' => 'La contraseña ha sido restablecida.']);
    } else {
        return response()->json(['message' => 'El token es inválido o ha expirado.'], 500);
    }
    }
}
