<?php

namespace App\Http\Controllers;

use App\Models\Notificacion;
use Illuminate\Http\Request;

class NotificacionController extends Controller
{
    public function store(Request $request)
    {
        
        $validated = $request->validate([
            'fecha' => 'required|date',  
            'texto' => 'required|string|max:255',  
        ]);

        Notificacion::create([
            'fecha' => $validated['fecha'],
            'texto' => $validated['texto'],
        ]);

        return response()->json(['message' => 'Notificación creada con éxito']);
    }

    public function index()
    {
        $notificaciones = Notificacion::select('id_notificacion', 'fecha', 'texto', 'created_at')
            ->orderBy('fecha', 'desc')
            ->get()
            ->map(function ($notificacion) {
                $notificacion->created_at = $notificacion->created_at->format('Y-m-d H:i:s'); // Formato deseado
                return $notificacion;
            });

        return response()->json($notificaciones);
    }

}
