<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        // Si la solicitud es una API (espera JSON), no redirige, simplemente devuelve null
        if ($request->expectsJson()) {
            return null;
        }

        // Para las solicitudes web, redirige a la ruta de login
        return route('login');
    }
}
