<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string  $role
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $role)
    {
        //---------Verificar si el usuario está autenticado------
        if (Auth::check()) {
            
            $user = Auth::user();

            //------Verificar si el usuario tiene el rol requerido----
            if ($user->hasRole($role)) {
                return $next($request);
            }
        }

        return response()->json(['message' => 'No tienes permiso para realizar esta acción'], 403);
    }
}
