<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InscripcionVerification extends Mailable
{
    use Queueable, SerializesModels;

    public $token;

    /**
     * Create a new message instance.
     */
    public function __construct(string $token)
    {
        $this->token = $token;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        $verifyUrl = config('app.url')
                     . '/api/inscripcion/confirmar?token='
                     . $this->token;

        return $this
            ->subject('Verifica tu correo para completar tu inscripción')
            ->markdown('emails.inscripcion.verify')
            ->with([
                'verifyUrl' => $verifyUrl,
            ]);
    }
}
