<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Adjunto extends Model
{
    protected $table = 'adjuntos';

    protected $primaryKey = 'id_adjunto';

    protected $fillable = ['id_publicacion', 'nombre_archivo', 'ruta_archivo', 'url'];

    //-----Relaciones-----
    public function publicacion()
    {
        return $this->belongsTo(Publicacion::class, 'id_publicacion');
    }
}
