<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Aprobacion extends Model
{
    use HasFactory;

    protected $table = 'aprobaciones';

    protected $primaryKey = 'id_aprobacion';

    protected $fillable = ['id_publicacion', 'id_user', 'fecha_aprobacion', 'estado', 'comentarios'];

    //--------Relación----------
    public function publicacion()
    {
        return $this->belongsTo(Publicacion::class, 'id_publicacion');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }
}
