<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Determinante extends Model
{
    protected $table = 'determinantes';

    protected $primaryKey = 'id_determinante';

    protected $fillable = ['nombre_determinante', 'descripcion'];

    //------Relaciones-----
    public function publicaciones()
    {
        return $this->belongsToMany(Publicacion::class, 'publicacion_determinante', 'id_determinante', 'id_publicacion');
    }
}
