<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Entidad extends Model
{
    use HasFactory;

    protected $table = 'entidades';

    protected $primaryKey = 'id_entidad';

    protected $fillable = ['nombre_entidad', 'descripcion', 'ciudad', 'direccion', 'telefono'];

    //-----Relaciones-----
    public function users()
    {
        return $this->hasMany(User::class, 'id_entidad');
    }
}
