<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EstadoPublicacion extends Model
{
    protected $table = 'estado_publicacion';

    protected $primaryKey = 'id_estado_publicacion';

    protected $fillable = ['nombre_estado', 'descripcion'];

    //----Relaciones-----
    public function publicaciones()
    {
        return $this->hasMany(Publicacion::class, 'id_estado_publicacion');
    }
}
