<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Publicacion extends Model
{
    use HasFactory;

    protected $table = 'publicaciones';
    protected $primaryKey = 'id_publicacion';

    protected $fillable = [
        'id_user', 
        'tipo_publicacion', 
        'titulo', 
        'contenido', 
        'fecha_creacion', 
        'id_estado_publicacion', 
        'fecha_aprobacion', 
        'url', 
        'descripcion', 
        'tipo_determinante',
        'portada',
        'fecha_actualizacion'
    ];

    //-------Relaciones-----------

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }

    public function estado()
    {
        return $this->belongsTo(EstadoPublicacion::class, 'id_estado_publicacion');
    }

    public function aprobaciones()
    {
        return $this->hasMany(Aprobacion::class, 'id_publicacion');
    }

    public function determinantes()
    {
        return $this->belongsToMany(Determinante::class, 'publicacion_determinante', 'id_publicacion', 'id_determinante');
    }

    public function adjuntos()
    {
        return $this->hasMany(Adjunto::class, 'id_publicacion');
    }

}