<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Rol extends Model
{
    use HasFactory;

    protected $table = 'roles';
    
    protected $primaryKey = 'id_rol';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = ['nombre_rol'];

    //------ Relaciones -------
    public function users()
    {
        return $this->hasMany(User::class, 'id_rol'); 
    }

    
    public function usersWithRole()
    {
        return $this->users()->get();
    }

    
    public static function roleExists($roleName)
    {
        return self::where('nombre_rol', $roleName)->exists();
    }
}
