<?php

namespace App\Models;

use App\Notifications\ResetPasswordNotification;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Laravel\Passport\HasApiTokens; // <-- cambiado desde Laravel\Sanctum\HasApiTokens

class User extends Authenticatable
{
    use HasApiTokens, HasFactory;

    protected $table = 'users';
    protected $primaryKey = 'id_user';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'nombre_usuario', 'password', 'ultima_sesion', 'nombre', 
        'apellido_paterno', 'apellido_materno', 'telefono', 'ci', 
        'email', 'id_estado_user', 'id_entidad', 'id_rol' 
    ];

    protected $hidden = ['password'];

    //----- Relaciones -----
    public function estado()
    {
        return $this->belongsTo(EstadoUser::class, 'id_estado_user');
    }

    public function rol()
    {
        return $this->belongsTo(Rol::class, 'id_rol'); 
    }

    public function publicaciones()
    {
        return $this->hasMany(Publicacion::class, 'id_user');
    }

    public function aprobaciones()
    {
        return $this->hasMany(Aprobacion::class, 'id_user');
    }
    
    public function entidad()
    {
        return $this->belongsTo(Entidad::class, 'id_entidad');
    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }
}
