<?php

namespace App\Notifications;

use Illuminate\Auth\Notifications\ResetPassword as BaseResetPassword;

class ResetPasswordNotification extends BaseResetPassword
{
    public function toMail($notifiable)
    {
        $url = url('/password/reset', $this->token) . '?email=' . urlencode($notifiable->email);

        return (new MailMessage)
            ->subject('Restablecer contraseña')
            ->line('Has recibido este correo porque solicitaste restablecer tu contraseña.')
            ->action('Restablecer contraseña', $url)
            ->line('Si no solicitaste este restablecimiento, no se requiere ninguna acción.');
    }
}
