<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Area;

class AreaPolicy
{
    /**
     * Determine whether the user can view any areas.
     */
    public function viewAny(User $user)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can view the area.
     */
    public function view(User $user, Area $area)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can create areas.
     */
    public function create(User $user)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can update the area.
     */
    public function update(User $user, Area $area)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can delete the area.
     */
    public function delete(User $user, Area $area)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can restore the area.
     */
    public function restore(User $user, Area $area)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can permanently delete the area.
     */
    public function forceDelete(User $user, Area $area)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }
}
