<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Determinante;

class DeterminantePolicy
{
    /**
     * Determine whether the user can view any determinantes.
     */
    public function viewAny(User $user)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can view the determinante.
     */
    public function view(User $user, Determinante $determinante)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']);
    }

    /**
     * Determine whether the user can create determinantes.
     */
    public function create(User $user)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']); // Cambiar a los roles necesarios para crear
    }

    /**
     * Determine whether the user can update the determinante.
     */
    public function update(User $user, Determinante $determinante)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']); // Cambiar a los roles necesarios para actualizar
    }

    /**
     * Determine whether the user can delete the determinante.
     */
    public function delete(User $user, Determinante $determinante)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']); // Cambiar a los roles necesarios para eliminar
    }

    /**
     * Determine whether the user can restore the determinante.
     */
    public function restore(User $user, Determinante $determinante)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']); // Cambiar a los roles necesarios para restaurar
    }

    /**
     * Determine whether the user can permanently delete the determinante.
     */
    public function forceDelete(User $user, Determinante $determinante)
    {
        return $user->hasRole(['SuperAdmin', 'Admin', 'Usuario']); // Cambiar a los roles necesarios para eliminar permanentemente
    }
}
