<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Laravel\Passport\Passport;
use Carbon\Carbon;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
{
    $this->registerPolicies();

    // Seguridad: solo llamar si la clase y el método existen
    if (class_exists(\Laravel\Passport\Passport::class) && method_exists(\Laravel\Passport\Passport::class, 'routes')) {
        \Laravel\Passport\Passport::routes();

        \Laravel\Passport\Passport::tokensCan([
            'place-orders' => 'Place orders',
            'view-account' => 'View account information',
        ]);

        \Laravel\Passport\Passport::tokensExpireIn(\Carbon\Carbon::now()->addDays(15));
        \Laravel\Passport\Passport::refreshTokensExpireIn(\Carbon\Carbon::now()->addDays(30));
    }
}

}
