<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\EstadoUser;
use App\Models\Entidad;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class UserFactory extends Factory
{
    protected $model = User::class;

    public function definition(): array
    {
        return [
            'nombre_usuario' => $this->faker->unique()->userName(),
            'password' => bcrypt(Str::random(10)), 
            'ultima_sesion' => now(),
            'nombre' => $this->faker->firstName(),
            'apellido_paterno' => $this->faker->lastName(),
            'apellido_materno' => $this->faker->lastName(),
            'telefono' => $this->faker->phoneNumber(),
            'ci' => $this->faker->unique()->numerify('##########'), 
            'email' => $this->faker->unique()->safeEmail(),
            'id_estado_user' => EstadoUser::factory(), 
            'id_entidad' => Entidad::factory(), 
        ];
    }
}
