<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    
    public function up(): void
    {
        Schema::create('entidades', function (Blueprint $table) {
            $table->bigIncrements('id_entidad');
            $table->string('nombre_entidad', 100);
            $table->text('descripcion')->nullable();
            $table->string('ciudad', 50);  
            $table->string('direccion', 150); 
            $table->string('telefono', 20);  
            $table->timestamps();

        });
    }

    
    public function down(): void
    {
        Schema::dropIfExists('entidades');
    }
};