<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id_user');
            $table->string('nombre_usuario', 100)->unique();
            $table->string('password');
            $table->timestamp('ultima_sesion')->nullable()->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('nombre', 100);
            $table->string('apellido_paterno', 100);
            $table->string('apellido_materno')->nullable();
            $table->string('telefono', 20)->nullable();
            $table->string('ci', 20)->nullable();
            $table->string('email', 150)->unique();
            $table->unsignedBigInteger('id_estado_user');
            $table->unsignedBigInteger('id_entidad')->nullable();
            $table->unsignedBigInteger('id_rol');
            $table->foreign('id_estado_user')->references('id_estado_user')->on('estado_users');
            $table->foreign('id_entidad')->references('id_entidad')->on('entidades');
            $table->foreign('id_rol')->references('id_rol')->on('roles'); 
            
            $table->rememberToken();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};