<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreatePublicacionesTable extends Migration
{
    public function up(): void
    {
        Schema::create('publicaciones', function (Blueprint $table) {
            $table->bigIncrements('id_publicacion'); 
            $table->unsignedBigInteger('id_user');
            

            $table->enum('tipo_publicacion', ['infografia', 'noticia', 'comunicado', 'video', 'pdf', 'imagen', 'otro']);
            $table->text('titulo');
            $table->text('contenido')->nullable();
            $table->text('url')->nullable(); 
            $table->text('descripcion')->nullable(); 
            $table->enum('tipo_determinante', ['Acceso a la Comunidad', 'Ingreso', 'Educación', 'Vivienda y acceso a servicios básicos', 'Seguridad Alimentaria', 'Género y Generalidades', 'Pluriculturalidad', 'Medio Ambiente y Cambio Climático', 'Crianza y Salud Mental']);
            $table->timestamp('fecha_aprobacion')->nullable();
            $table->timestamp('fecha_actualizacion')->nullable();
            $table->text('portada')->nullable(); 

            $table->timestamp('fecha_creacion')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->unsignedBigInteger('id_estado_publicacion');
            $table->foreign('id_user')->references('id_user')->on('users')->onDelete('cascade');
            $table->foreign('id_estado_publicacion')->references('id_estado_publicacion')->on('estado_publicacion');
            $table->timestamps();
        });
    }



    public function down(): void
    {
        Schema::dropIfExists('publicaciones');
    }
}