<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateAprobacionesTable extends Migration
{
    public function up(): void
    {
        Schema::create('aprobaciones', function (Blueprint $table) {
            $table->bigIncrements('id_aprobacion'); 
            $table->unsignedBigInteger('id_publicacion');
            $table->unsignedBigInteger('id_user');  
            
            $table->timestamp('fecha_aprobacion')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->enum('estado', ['rechazado', 'aprobado']);
            $table->text('comentarios')->nullable();
            $table->foreign('id_publicacion')->references('id_publicacion')->on('publicaciones')->onDelete('cascade');
            $table->foreign('id_user')->references('id_user')->on('users')->onDelete('cascade'); 
    
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('aprobaciones');
    }
}