<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    
    public function up(): void
    {
        Schema::create('publicacion_determinante', function (Blueprint $table) {
            $table->unsignedBigInteger('id_publicacion');
            $table->unsignedBigInteger('id_determinante');
            $table->primary(['id_publicacion', 'id_determinante']);
            $table->foreign('id_publicacion')->references('id_publicacion')->on('publicaciones')->onDelete('cascade');
            $table->foreign('id_determinante')->references('id_determinante')->on('determinantes')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('publicacion_determinante');
    }
};
