<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('log_aprobaciones', function (Blueprint $table) {
            $table->bigIncrements('id_log_aprobacion');
            $table->unsignedBigInteger('id_aprobacion');
            $table->enum('accion', ['creación', 'actualización', 'eliminación']);
            $table->text('datos_anterior')->nullable();
            $table->text('datos_nuevo')->nullable();
            $table->timestamp('fecha')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->unsignedBigInteger('id_user')->nullable();
            $table->foreign('id_aprobacion')->references('id_aprobacion')->on('aprobaciones')->onDelete('cascade');
            $table->foreign('id_user')->references('id_user')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('log_aprobaciones');
    }
};
