<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('log_users', function (Blueprint $table) {
            $table->bigIncrements('id_log_user');
            $table->unsignedBigInteger('id_user');
            $table->enum('accion', ['creación', 'actualización', 'eliminación']);
            $table->text('datos_anterior')->nullable();
            $table->text('datos_nuevo')->nullable();
            $table->timestamp('fecha')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->unsignedBigInteger('id_admin')->nullable();
            $table->foreign('id_user')->references('id_user')->on('users')->onDelete('cascade');
            $table->foreign('id_admin')->references('id_user')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('log_users');
    }
};
