<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quizzes', function (Blueprint $table) {
$table->bigIncrements('id_quiz');
$table->unsignedBigInteger('id_proyecto');
$table->unsignedBigInteger('id_user')->nullable();
$table->string('titulo', 255);
$table->text('descripcion')->nullable();
$table->enum('tipo', ['puntaje', 'condicional', 'mixto'])->default('puntaje');
$table->integer('version')->default(1);
$table->boolean('visible')->default(false);
$table->dateTime('fecha_visible_desde')->nullable();
$table->dateTime('fecha_visible_hasta')->nullable();
$table->timestamps();


$table->index('id_proyecto', 'idx_quizzes_proyecto');
$table->index('visible', 'idx_quizzes_visible');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quizzes');
    }
};
