<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_questions', function (Blueprint $table) {
$table->bigIncrements('id_pregunta');
$table->unsignedBigInteger('id_quiz');
$table->integer('orden')->default(0);
$table->text('texto_pregunta');
$table->enum('tipo_pregunta', ['single', 'multiple', 'open_text', 'numeric', 'date', 'likert', 'slider', 'boolean'])->default('single');
$table->string('ayuda', 255)->nullable();
$table->timestamps();


$table->unique(['id_quiz', 'orden'], 'ux_quiz_questions_quiz_orden');
$table->index('id_quiz', 'idx_quiz_questions_quiz');


$table->foreign('id_quiz', 'fk_quiz_questions_quiz')
->references('id_quiz')->on('quizzes')->onDelete('cascade');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_questions');
    }
};
