<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('question_options', function (Blueprint $table) {
$table->bigIncrements('id_opcion');
$table->unsignedBigInteger('id_pregunta');
$table->text('texto_opcion');
$table->string('etiqueta', 100)->nullable();
$table->decimal('valor', 6, 2)->default(0);
$table->integer('orden')->default(0);
$table->timestamps();


$table->unique(['id_pregunta', 'orden'], 'ux_question_options_pregunta_orden');
$table->index('id_pregunta', 'idx_question_options_pregunta');


$table->foreign('id_pregunta', 'fk_question_options_pregunta')
->references('id_pregunta')->on('quiz_questions')->onDelete('cascade');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('question_options');
    }
};
