<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_result_rules', function (Blueprint $table) {
$table->bigIncrements('id_regla');
$table->unsignedBigInteger('id_quiz');
$table->enum('tipo_regla', ['rango', 'condicional'])->default('rango');
$table->string('condicion', 500)->nullable();
$table->integer('puntaje_min')->nullable();
$table->integer('puntaje_max')->nullable();
$table->string('titulo', 100)->nullable();
$table->text('descripcion')->nullable();
$table->integer('prioridad')->default(0);
$table->boolean('activo')->default(true);
$table->timestamps();


$table->index('id_quiz', 'idx_quiz_result_rules_quiz');


$table->foreign('id_quiz', 'fk_quiz_result_rules_quiz')
->references('id_quiz')->on('quizzes')->onDelete('cascade');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_result_rules');
    }
};
