<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_results', function (Blueprint $table) {
$table->bigIncrements('id_resultado');
$table->unsignedBigInteger('id_quiz');
$table->unsignedBigInteger('id_user')->nullable();
$table->integer('puntuacion_total')->nullable();
$table->text('resultado_texto')->nullable();
$table->dateTime('fecha_inicio')->nullable();
$table->dateTime('fecha_fin')->nullable();
$table->integer('quiz_version')->nullable();
$table->timestamps();


$table->index('id_quiz', 'idx_quiz_results_quiz');
$table->index('id_user', 'idx_quiz_results_user');


$table->foreign('id_quiz', 'fk_quiz_results_quiz')
->references('id_quiz')->on('quizzes')->onDelete('cascade');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_results');
    }
};
