<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_answers', function (Blueprint $table) {
$table->bigIncrements('id_answer');
$table->unsignedBigInteger('id_resultado');
$table->unsignedBigInteger('id_pregunta');
$table->enum('tipo_respuesta', ['opcion_unica', 'opcion_multiple', 'texto', 'numero', 'fecha', 'slider', 'boolean']);
$table->text('respuesta_text')->nullable();
$table->decimal('valor_numerico', 8, 2)->nullable();
$table->timestamps();


$table->index('id_resultado', 'idx_quiz_answers_result');
$table->index('id_pregunta', 'idx_quiz_answers_pregunta');


$table->foreign('id_resultado', 'fk_quiz_answers_result')
->references('id_resultado')->on('quiz_results')->onDelete('cascade');


$table->foreign('id_pregunta', 'fk_quiz_answers_pregunta')
->references('id_pregunta')->on('quiz_questions')->onDelete('cascade');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_answers');
    }
};
