<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_answer_options', function (Blueprint $table) {
$table->bigIncrements('id');
$table->unsignedBigInteger('id_answer');
$table->unsignedBigInteger('id_opcion')->nullable();
$table->text('opcion_snapshot_text')->nullable();
$table->decimal('opcion_snapshot_valor', 8, 2)->nullable();
$table->timestamp('created_at')->useCurrent();


$table->index('id_answer', 'idx_quiz_answer_options_answer');
$table->index('id_opcion', 'idx_quiz_answer_options_opcion');


$table->foreign('id_answer', 'fk_quiz_answer_options_answer')
->references('id_answer')->on('quiz_answers')->onDelete('cascade');


$table->foreign('id_opcion', 'fk_quiz_answer_options_opcion')
->references('id_opcion')->on('question_options')->onDelete('set null');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_answer_options');
    }
};
