<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('integrantes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('id_proyecto');
            $table->unsignedBigInteger('id_user');
            // prefiero useCurrent en vez de DB::raw
            $table->timestamp('fecha_ingreso')->nullable();
            $table->dateTime('fecha_salida')->nullable();
            $table->timestamps();

            

            // Ajusta las columnas referenciadas si tu users tiene PK llamada `id` en vez de `id_user`
            $table->foreign('id_proyecto', 'fk_integrantes_proyecto')
                  ->references('id_proyecto')->on('proyectos')->onDelete('cascade');

            $table->foreign('id_user', 'fk_integrantes_user')
                  ->references('id_user')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('integrantes');
    }
};
