<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
public function up(): void
{
Schema::create('secciones', function (Blueprint $table) {
$table->bigIncrements('id_seccion');
$table->unsignedBigInteger('id_proyecto');
$table->string('nombre', 150);
$table->text('descripcion')->nullable();
$table->integer('orden')->default(0);
$table->boolean('visible')->default(true);
$table->timestamps();


$table->index('id_proyecto', 'idx_secciones_proyecto');
$table->unique(['id_proyecto', 'nombre'], 'uq_secciones_proyecto_nombre');


$table->foreign('id_proyecto', 'fk_secciones_proyecto')
->references('id_proyecto')->on('proyectos')
->onDelete('cascade');


});
}


public function down(): void
{
Schema::dropIfExists('secciones');
}
};