<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
public function up(): void
{
Schema::create('categorias', function (Blueprint $table) {
$table->bigIncrements('id_categoria');
$table->unsignedBigInteger('id_seccion');
$table->string('nombre', 150);
$table->text('descripcion')->nullable();
$table->integer('orden')->default(0);
$table->boolean('visible')->default(true);
$table->timestamps();


$table->index('id_seccion', 'idx_categorias_seccion');
$table->unique(['id_seccion', 'nombre'], 'uq_categorias_seccion_nombre');


$table->foreign('id_seccion', 'fk_categorias_seccion')
->references('id_seccion')->on('secciones')
->onDelete('cascade');
});
}


public function down(): void
{
Schema::dropIfExists('categorias');
}
};