<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('recurso_archivos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('id_recurso');
            $table->string('ruta', 1000);
            $table->string('nombre_original', 255)->nullable();
            $table->enum('tipo_archivo', ['imagen','documento','video','otro'])->default('imagen');
            $table->integer('orden')->default(0);
            $table->timestamps();

            $table->index('id_recurso', 'idx_recurso_archivos_recurso');

            $table->foreign('id_recurso', 'fk_recurso_archivos_recurso')
                  ->references('id_recurso')->on('recursos')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('recurso_archivos');
    }
};
