<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
public function up(): void
{
Schema::create('revisiones', function (Blueprint $table) {
$table->bigIncrements('id_revision');
$table->unsignedBigInteger('id_recurso');
$table->unsignedBigInteger('id_user')->nullable();
$table->unsignedBigInteger('id_estado');
$table->timestamp('fecha_revision')->useCurrent();
$table->text('comentarios')->nullable();


$table->index('id_recurso', 'idx_revisiones_recurso');
$table->index('id_user', 'idx_revisiones_user');
$table->index('id_estado', 'idx_revisiones_estado');


$table->foreign('id_recurso', 'fk_revisiones_recurso')
->references('id_recurso')->on('recursos')->onDelete('cascade');


$table->foreign('id_user', 'fk_revisiones_user')
->references('id_user')->on('users')->onDelete('set null');


$table->foreign('id_estado', 'fk_revisiones_estado')
->references('id_estado')->on('estados')->onDelete('restrict');
});
}


public function down(): void
{
Schema::table('revisiones', function (Blueprint $table) {
try { $table->dropForeign('fk_revisiones_recurso'); } catch (\Exception $e) {}
try { $table->dropForeign('fk_revisiones_user'); } catch (\Exception $e) {}
try { $table->dropForeign('fk_revisiones_estado'); } catch (\Exception $e) {}
});


Schema::dropIfExists('revisiones');
}
};