<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EstadoPublicacion;

class EstadoPublicacionSeeder extends Seeder
{
    public function run(): void
    {
        $estados = [
            ['nombre_estado' => 'en_elaboracion', 'descripcion' => 'La publicación está en proceso de creación.'],
            ['nombre_estado' => 'pendiente', 'descripcion' => 'La publicación está pendiente de aprobación.'],
            ['nombre_estado' => 'aprobado', 'descripcion' => 'La publicación ha sido aprobada.'],
            ['nombre_estado' => 'rechazado', 'descripcion' => 'La publicación ha sido rechazada.'],
        ];

        foreach ($estados as $estado) {
            EstadoPublicacion::create($estado);
        }
    }
}
