<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EstadoUserSeeder extends Seeder
{
    public function run(): void
    {
        //------Desactivar las clave foránea---
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        //------Eliminar los registros----
        DB::table('estado_users')->delete();

        //-------Registr los datos------
        DB::table('estado_users')->insert([
            ['id_estado_user' => 1, 'nombre_estado' => 'activo', 'descripcion' => 'Estado Activo'],
            ['id_estado_user' => 2, 'nombre_estado' => 'inactivo', 'descripcion' => 'Estado Inactivo'],
            ['id_estado_user' => 3, 'nombre_estado' => 'suspendido', 'descripcion' => 'Estado Suspendido'],
        ]);
        

        //------Activar las clave foránea------
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
