<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Rol;
use App\Models\EstadoUser;
use App\Models\Entidad;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        //------Obtener el estado 'activo' para los usuarios
        $estadoUser = EstadoUser::where('nombre_estado', 'activo')->first();

        //------Obtener las entidades
        $entidadProcosi = Entidad::where('nombre_entidad', 'PROCOSI')->first();
        $entidadAPROSAR = Entidad::where('nombre_entidad', 'APROSAR')->first();
        $entidadAYUDA = Entidad::where('nombre_entidad', 'AYUDA EN ACCION')->first();
        $entidadCECASEM = Entidad::where('nombre_entidad', 'CECASEM')->first();
        $entidadCEMSE = Entidad::where('nombre_entidad', 'CEMSE')->first();
        $entidadCEPAC = Entidad::where('nombre_entidad', 'CEPAC')->first();
        $entidadCIES = Entidad::where('nombre_entidad', 'CIES')->first();
        $entidadCSRA = Entidad::where('nombre_entidad', 'CSRA')->first();
        $entidadCHILD = Entidad::where('nombre_entidad', 'CHILD FUND')->first();
        $entidadCRECER = Entidad::where('nombre_entidad', 'CRECER')->first();
        $entidadESPERANZA = Entidad::where('nombre_entidad', 'ESPERANZA BOLIVIA')->first();
        $entidadFHB = Entidad::where('nombre_entidad', 'FHB')->first();
        $entidadIPTK = Entidad::where('nombre_entidad', 'IPTK')->first();
        $entidadMISION = Entidad::where('nombre_entidad', 'MISIÓN ALIANZA NORUEGA EN BOLIVIA')->first();
        $entidadPASTORAL = Entidad::where('nombre_entidad', 'PASTORAL SOCIAL CARITAS BOLIVIANA')->first();
        $entidadPLAN = Entidad::where('nombre_entidad', 'PLAN INTERNATIONAL')->first();
        $entidadPROAGRO = Entidad::where('nombre_entidad', 'PROAGRO')->first();
        $entidadPROMUJER = Entidad::where('nombre_entidad', 'PROMUJER')->first();
        $entidadPROSALUD = Entidad::where('nombre_entidad', 'PROSALUD')->first();
        $entidadSAVE = Entidad::where('nombre_entidad', 'SAVE THE CHILDREN')->first();
        $entidadUNIVERSIDAD = Entidad::where('nombre_entidad', 'UNIVERSIDAD NUR')->first();
        $entidadFUNDESOC = Entidad::where('nombre_entidad', 'FUNDESOC')->first();
        $entidadFUNDACION = Entidad::where('nombre_entidad', 'FUNDACION DE WAAL')->first();
        $entidadUBPFUNDACIONOJOS = Entidad::where('nombre_entidad', 'FUNDACION OJOS DEL MUNDO')->first();


        //-----Obtener los roles
        $superAdminRole = Rol::where('nombre_rol', 'SuperAdmin')->first();
        $adminRole = Rol::where('nombre_rol', 'Admin')->first();
        $usuarioRole = Rol::where('nombre_rol', 'Usuario')->first();

        //------Verificar que los registros existen
        if (!$estadoUser  || !$entidadProcosi || !$entidadAPROSAR || !$entidadAYUDA || !$entidadCECASEM || !$entidadCEMSE
        || !$entidadCEPAC || !$entidadCIES || !$entidadCSRA || !$entidadCHILD || !$entidadCRECER || !$entidadESPERANZA || !$entidadFHB || !$entidadIPTK || !$entidadMISION || !$entidadPASTORAL
        || !$entidadPLAN || !$entidadPROAGRO || !$entidadPROMUJER || !$entidadPROSALUD || !$entidadSAVE || !$entidadUNIVERSIDAD || !$entidadFUNDESOC || !$entidadFUNDACION || !$entidadUBPFUNDACIONOJOS
        || !$superAdminRole || !$adminRole || !$usuarioRole) {
            throw new \Exception('Uno de los estados, entidades o roles no existe en la base de datos');
        }

        //-----Creacion de los usuarios

        User::create([
            'nombre_usuario' => 'sistemas',
            'password' => Hash::make('12345678'),
            'ultima_sesion' => now(),
            'nombre' => 'Juan',
            'apellido_paterno' => 'Titirico',
            'apellido_materno' => '',
            'telefono' => '60115279',
            'ci' => '',
            'email' => 'juan.titirico@procosi.org.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadProcosi->id_entidad,
            'id_rol' => $superAdminRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'APROSAR',
            'password' => Hash::make('Aprosar1011'),
            'ultima_sesion' => now(),
            'nombre' => 'Anastacio',
            'apellido_paterno' => 'Choque',
            'apellido_materno' => '',
            'telefono' => '71844728',
            'ci' => '',
            'email' => 'achoque@aprosarbolivia.org.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadAPROSAR->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'AEA',
            'password' => Hash::make('Ayudaenaccion1022'),
            'ultima_sesion' => now(),
            'nombre' => 'Isabel',
            'apellido_paterno' => 'Cajias',
            'apellido_materno' => '',
            'telefono' => '72035344',
            'ci' => '',
            'email' => 'icajias@ayudaenaccion.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadAYUDA->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CECASEM',
            'password' => Hash::make('Cecasem1033'),
            'ultima_sesion' => now(),
            'nombre' => 'Patricia',
            'apellido_paterno' => 'Bustamante',
            'apellido_materno' => '',
            'telefono' => '71225714',
            'ci' => '',
            'email' => 'direccion@mailcecasem.com ',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadCECASEM->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CEMSE',
            'password' => Hash::make('Cemse1044'),
            'ultima_sesion' => now(),
            'nombre' => 'Federico',
            'apellido_paterno' => 'Escobar',
            'apellido_materno' => '',
            'telefono' => '77227400',
            'ci' => '',
            'email' => 'federicoe@cemse.edu.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadCEMSE->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CEPAC',
            'password' => Hash::make('Cepac1055'),
            'ultima_sesion' => now(),
            'nombre' => 'Widen',
            'apellido_paterno' => 'Abastoflor',
            'apellido_materno' => '',
            'telefono' => '72462261',
            'ci' => '',
            'email' => 'widen@cepac.org.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadCEPAC->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CIES',
            'password' => Hash::make('Cies1066'),
            'ultima_sesion' => now(),
            'nombre' => 'Jhonny',
            'apellido_paterno' => 'Lopez',
            'apellido_materno' => '',
            'telefono' => '76768121',
            'ci' => '',
            'email' => 'jlopez@cies.org.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadCIES->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CSRA',
            'password' => Hash::make('crsa1077'),
            'ultima_sesion' => now(),
            'nombre' => 'Ramiro',
            'apellido_paterno' => 'Llanque',
            'apellido_materno' => '',
            'telefono' => '71982945',
            'ci' => '',
            'email' => 'rllanque@csra-bolivia.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadCSRA->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CFB',
            'password' => Hash::make('Childfund1088'),
            'ultima_sesion' => now(),
            'nombre' => 'Ximena',
            'apellido_paterno' => 'Loza',
            'apellido_materno' => '',
            'telefono' => '77746168',
            'ci' => '',
            'email' => 'xloza@childfund.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadCHILD->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CRECER',
            'password' => Hash::make('Crecer1099'),
            'ultima_sesion' => now(),
            'nombre' => 'Jóse',
            'apellido_paterno' => 'Auad',
            'apellido_materno' => '',
            'telefono' => '72022060',
            'ci' => '',
            'email' => 'jauad@crecerifd.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadCRECER->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'OEB',
            'password' => Hash::make('Esperanza2011'),
            'ultima_sesion' => now(),
            'nombre' => 'Palmira',
            'apellido_paterno' => 'Villaroel',
            'apellido_materno' => '',
            'telefono' => '67370808',
            'ci' => '',
            'email' => 'pvillarroel@esperanzabolivia.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadESPERANZA->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'FHB',
            'password' => Hash::make('Fhbolivia2022'),
            'ultima_sesion' => now(),
            'nombre' => 'Marcelo',
            'apellido_paterno' => 'Vizcarra',
            'apellido_materno' => '',
            'telefono' => '78890230',
            'ci' => '',
            'email' => 'mviscarra@fh.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadFHB->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'IPTK',
            'password' => Hash::make('Iptk2033'),
            'ultima_sesion' => now(),
            'nombre' => 'Alejandro',
            'apellido_paterno' => 'Barrios',
            'apellido_materno' => '',
            'telefono' => '68623003',
            'ci' => '',
            'email' => 'direcciongeneral@iptk.org.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadIPTK->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'MANB',
            'password' => Hash::make('MisionAlianza2044'),
            'ultima_sesion' => now(),
            'nombre' => 'Marleni',
            'apellido_paterno' => 'Surco',
            'apellido_materno' => '',
            'telefono' => '71596340',
            'ci' => '',
            'email' => 'marleni.surco@misionalianza.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadMISION->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'CARITAS',
            'password' => Hash::make('CaritasBolivia2055'),
            'ultima_sesion' => now(),
            'nombre' => 'Elizabeth',
            'apellido_paterno' => 'Zabala',
            'apellido_materno' => '',
            'telefono' => '65164770',
            'ci' => '',
            'email' => 'direccion@caritasbolivia.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadPASTORAL->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'PIB',
            'password' => Hash::make('Planinternacional2066'),
            'ultima_sesion' => now(),
            'nombre' => 'Marco',
            'apellido_paterno' => 'Rojas',
            'apellido_materno' => '',
            'telefono' => '72020765',
            'ci' => '',
            'email' => 'marco.rojas@plan-international.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadPLAN->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'PROAGRO',
            'password' => Hash::make('Proagro2077'),
            'ultima_sesion' => now(),
            'nombre' => 'Sergio',
            'apellido_paterno' => 'Aparicio',
            'apellido_materno' => '',
            'telefono' => '69690969',
            'ci' => '',
            'email' => 'apariciosergio@proagro.net.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadPROAGRO->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'PROMUJER',
            'password' => Hash::make('Promujer2088'),
            'ultima_sesion' => now(),
            'nombre' => 'Cecilia',
            'apellido_paterno' => 'Campera',
            'apellido_materno' => '',
            'telefono' => '72024804',
            'ci' => '',
            'email' => 'cecilia.campero@promujer.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadPROMUJER->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'PROSALUD',
            'password' => Hash::make('Prosalud2099'),
            'ultima_sesion' => now(),
            'nombre' => 'Martha',
            'apellido_paterno' => 'Mérida',
            'apellido_materno' => '',
            'telefono' => '654987321',
            'ci' => '',
            'email' => 'mmerida@prosalud.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadPROSALUD->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'STCB',
            'password' => Hash::make('Savethechildren3011'),
            'ultima_sesion' => now(),
            'nombre' => 'Marianela',
            'apellido_paterno' => 'Montes de Oca',
            'apellido_materno' => '',
            'telefono' => '77233666',
            'ci' => '',
            'email' => 'marianela.montesdeoca@savethechildren.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadSAVE->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'UNUR',
            'password' => Hash::make('Unur3022'),
            'ultima_sesion' => now(),
            'nombre' => 'William',
            'apellido_paterno' => 'Shoaie',
            'apellido_materno' => '',
            'telefono' => '76392446',
            'ci' => '',
            'email' => 'wshoaie@nur.edu',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadUNIVERSIDAD->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'FUNDESOC',
            'password' => Hash::make('Fundesoc3033'),
            'ultima_sesion' => now(),
            'nombre' => 'Maria',
            'apellido_paterno' => 'Montore',
            'apellido_materno' => '',
            'telefono' => '71093935',
            'ci' => '',
            'email' => 'direccion.ejecutiva@fundesoc.org.bo',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadFUNDESOC->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'FDW',
            'password' => Hash::make('Waal3044'),
            'ultima_sesion' => now(),
            'nombre' => 'Elmer',
            'apellido_paterno' => 'Vega',
            'apellido_materno' => '',
            'telefono' => '73779760',
            'ci' => '',
            'email' => 'evega@fdwaal.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadFUNDACION->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);

        User::create([
            'nombre_usuario' => 'ODM',
            'password' => Hash::make('Ojosdelmundo3055'),
            'ultima_sesion' => now(),
            'nombre' => 'Patricia',
            'apellido_paterno' => 'Tarraga',
            'apellido_materno' => '',
            'telefono' => '67005815',
            'ci' => '',
            'email' => 'ptarraga@ojosdelmundo.org',
            'id_estado_user' => $estadoUser->id_estado_user,
            'id_entidad' => $entidadUBPFUNDACIONOJOS->id_entidad,
            'id_rol' => $usuarioRole->id_rol, 
        ]);
    }
}
