<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiTestController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\RolController;
use App\Http\Controllers\API\UserStatusController;
use App\Http\Controllers\API\PublicacionController;
use App\Http\Controllers\API\AprobacionController;
use App\Http\Controllers\API\AreaController;
use App\Http\Controllers\API\DeterminanteController;
use App\Http\Controllers\API\EntidadController;
use App\Http\Controllers\API\InscripcionController;
use App\Http\Controllers\API\EstadoPublicacionController;
use App\Http\Controllers\API\ListarController;
use App\Http\Controllers\NotificacionController;
use App\Http\Controllers\Auth\PasswordResetController;
use App\Http\Controllers\MailTestController;
use App\Http\Controllers\API\ProyectosController;
use App\Http\Controllers\API\QuizesController;
use App\Http\Controllers\API\RecursosController;
use App\Http\Controllers\API\PublicQuizzesController;
use App\Http\Controllers\API\SeccionesController;
use App\Http\Controllers\API\TiposPublicacionController;
use App\Http\Controllers\API\CategoriasController;
use App\Http\Controllers\API\RecursosPublicController;


Route::get('public/consejos', [RecursosPublicController::class, 'index']);
Route::get('public/biblioteca-recursos', [RecursosPublicController::class, 'bibliotecaRecursos']);
Route::get('/public/quizzes', [PublicQuizzesController::class, 'index']);
Route::get('/public/quizzes/{id}', [PublicQuizzesController::class, 'show']);
Route::post('/public/quizzes/{id}/submit', [PublicQuizzesController::class, 'submit']);

Route::post('/password/forgot', [PasswordResetController::class, 'forgot']);
Route::post('/reset-password', [PasswordResetController::class, 'reset']);


//Route::middleware('auth:api')->get('/user', function (Request $request) {
    //return $request->user();
//});


Route::controller(UserController::class)->group(function () {
    Route::post('login', 'login');
    Route::post('logout', 'logout')->middleware('auth:api'); // <- cambiado
    Route::get('me', 'me')->middleware('auth:api');         // <- cambiado
});

Route::middleware('auth:api', 'throttle:60,1')->controller(UserController::class)->group(function () {
    
    Route::post('create/users', 'store');
    Route::post('users/change-password', 'changePassword');
    Route::get('users', 'index');
    Route::get('users/{id}', 'show');
    Route::put('update/users/{id}', 'update');
    Route::delete('delete/users/{id}', 'destroy');
    Route::put('update/users2/{id}', 'update2');
        
});



Route::middleware('auth:api', 'throttle:100,1')->controller(PublicacionController::class)->group(function () {
    Route::post('create/publicaciones', 'store');
    Route::put('up/publicaciones/{id}', 'update');
    Route::get('/publicaciones/{id}', 'show');
    Route::delete('delete/publicaciones/{id}', 'destroy');
    Route::get('/publicaciones', 'index');
    Route::get('publicaciones/pendientes/count', 'PendientesTotal');
});

Route::controller(NotificacionController::class)->group(function () {
    Route::get('notificaciones', 'index')->middleware('auth:api'); 
    Route::post('create/notificaciones', 'store')->middleware('auth:api'); 
});

Route::get('/aprobaciones/aprobadasUno', [AprobacionController::class, 'listarAprobadosUno']);
Route::get('/aprobaciones/aprobadasDos', [AprobacionController::class, 'listarAprobadosDos']);
Route::get('/aprobaciones/aprobadasTres', [AprobacionController::class, 'listarAprobadosTres']);
Route::get('/aprobaciones/aprobadasCuatro', [AprobacionController::class, 'listarAprobadosCuatro']);
Route::get('/aprobaciones/aprobadasCinco', [AprobacionController::class, 'listarAprobadosCinco']);
Route::get('/aprobaciones/aprobadasSeis', [AprobacionController::class, 'listarAprobadosSeis']);
Route::get('/aprobaciones/aprobadasSiete', [AprobacionController::class, 'listarAprobadosSiete']);
Route::get('/aprobaciones/aprobadasOcho', [AprobacionController::class, 'listarAprobadosOcho']);
Route::get('/aprobaciones/aprobadasNueve', [AprobacionController::class, 'listarAprobadosNueve']);
Route::get('/aprobaciones/aprobadasDiez', [AprobacionController::class, 'listarAprobadosDiez']);

Route::post('/create/inscripcion', [InscripcionController::class, 'store']);
Route::get('inscripcion/confirmar', [InscripcionController::class, 'confirm']);

Route::middleware('auth:api', 'throttle:100,1')->controller(AprobacionController::class)->group(function () {
    Route::get('/aprobaciones/pendientes', 'listarPendientes');
    Route::get('/aprobaciones/rechazadas', 'listarRechazados');
    Route::get('/aprobaciones/aprobadas', 'listarAprobados');
    //Route::get('/aprobaciones/aprobadasUno', 'listarAprobadosUno');
    Route::put('/aprobaciones/aprobar/{id}', 'aprobar');
    Route::post('/aprobaciones/aprobarPortada/{id}', 'aprobarPortada');
    Route::put('/aprobaciones/rechazar/{id}', 'rechazar');
    Route::get('/aprobaciones/total-Aprobados', 'AprobadosTotal');
    Route::get('/aprobaciones/total-Rechazados', 'RechazadosTotal');
   // Route::get('/aprobaciones/{id}', 'verPublicacion'); 
    //Route::get('/aprobaciones/pendiente/{id}', 'verPendiente'); 
    //Route::get('/publicaciones/area-habitos-saludables', 'listarPrimeraArea');
    
});


Route::controller(RolController::class)->group(function () {
    Route::get('roles', 'index')->middleware('auth:api'); 
    Route::post('create/roles', 'store')->middleware('auth:api'); 
    Route::put('update/roles/{id}', 'update')->middleware('auth:api'); 
    Route::delete('delete/roles/{id}', 'destroy')->middleware('auth:api');
});

Route::controller(UserStatusController::class)->group(function () {
    Route::get('user-status', 'index')->middleware('auth:api'); 
    Route::put('update/user-status/{id}', 'updateStatus')->middleware('auth:api'); 
});

Route::middleware('auth:api')->controller(AreaController::class)->group(function () {
    Route::post('create/areas', 'store');
    Route::put('update/areas/{id}', 'update');
    Route::get('/areas/{id}', 'show');
    Route::delete('delete/areas/{id}', 'destroy');
    Route::get('/areas', 'index');
});


Route::middleware('auth:api')->controller(DeterminanteController::class)->group(function () {
    Route::post('create/determinantes', 'store');
    Route::put('update/determinantes/{id}', 'update');
    Route::get('/determinantes/{id}', 'show');
    Route::delete('delete/determinantes/{id}', 'destroy');
    Route::get('/determinantes', 'index');
});

Route::middleware('auth:api')->controller(EntidadController::class)->group(function () {
    Route::post('create/entidades', 'store');
    Route::get('/entidades', 'index');
    Route::put('update/entidades/{id}', 'update');
});

Route::middleware('auth:api')->controller(EstadoPublicacionController::class)->group(function () {
    Route::post('estado-publicacion', 'store');
    Route::get('estado-publicacion', 'index');
    Route::get('estado-publicacion/{id}', 'show');
    Route::put('estado-publicacion/{id}', 'update');
    Route::delete('estado-publicacion/{id}', 'destroy');
});

Route::controller(ProyectosController::class)->group(function () {
    Route::middleware('auth:api')->group(function () {
        Route::get('proyectos', 'index');
        Route::post('create/proyecto', 'store');
        Route::put('update/proyecto/{id}', 'update');
    });
});

Route::controller(QuizesController::class)->group(function () {
    Route::middleware('auth:api')->group(function () {
        Route::get('quizzes', 'index');
        Route::post('create/quizze', 'store');
        Route::put('update/quizze/{id}', 'update');
    });
});

Route::controller(RecursosController::class)->group(function () {
    Route::middleware('auth:api')->group(function () {
        Route::get('recursos', 'index');
        Route::post('create/recurso', 'store');
        Route::put('update/recurso/{id}', 'update');
        Route::post('recursos/{id}/revision', 'revision');
        Route::put('update/revision/{id}', 'updateRevision');
    });
});

Route::controller(SeccionesController::class)->group(function () {
    Route::middleware('auth:api')->group(function () {
        Route::get('secciones', 'index');
        Route::post('create/seccion', 'store');
        Route::put('update/seccion/{id}', 'update');
    });
});

Route::controller(CategoriasController::class)->group(function () {
    Route::middleware('auth:api')->group(function () {
        Route::get('categorias', 'index');
        Route::post('create/categoria', 'store');
        Route::put('update/categoria/{id}', 'update');
    });
});

Route::controller(TiposPublicacionController::class)->group(function () {
    Route::middleware('auth:api')->group(function () {
        Route::get('tipospublicaciones', 'index');
        Route::post('create/tipopublicacion', 'store');
        Route::put('update/tipopublicacion/{id}', 'update');
    });
});